<?php
session_start();

// Redirect to login page if session 'uid' is not set
if (!isset($_SESSION['uid'])) {
  header('Location: login.php');
  exit(); // Make sure to stop execution after redirect
}

// If session 'uid' is set, continue to display the page content

// Database connection
$conn = mysqli_connect("localhost", "tqualcou", "Technocrats.59", "tqualcou_tiosh");

// Check connection
if (!$conn) {
  die("Connection failed: " . mysqli_connect_error());
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">
  <link rel="icon" href="../img/Logos/technocrat.jpg" type="image/gif" sizes="16x16">
  <title>TIOSH Pvt Ltd</title>
  <link href="dashboard/vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
  <link href="dashboard/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css">
  <link href="dashboard/css/ruang-admin.min.css" rel="stylesheet">
  <link href="dashboard/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">
  <div id="wrapper">
    <div id="content-wrapper" class="d-flex flex-column">
      <div id="content">
        <!-- TopBar -->
        <nav class="navbar navbar-expand navbar-light bg-navbar topbar mb-4 static-top">
          <!-- <button id="sidebarToggleTop" class="btn btn-link rounded-circle mr-3">
            <i class="fa fa-bars"></i> Insert Logo here
          </button> -->
          <ul class="navbar-nav ml-auto">
            <li class="nav-item dropdown no-arrow">
              <a class="nav-link dropdown-toggle" href="#" id="searchDropdown" role="button" data-toggle="dropdown"
                aria-haspopup="true" aria-expanded="false">
                <i class="fas fa-search fa-fw"></i>
              </a>
              <div class="dropdown-menu dropdown-menu-right p-3 shadow animated--grow-in"
                aria-labelledby="searchDropdown">
                <form class="navbar-search">
                  <div class="input-group">
                    <input type="text" class="form-control bg-light border-1 small" placeholder="Search for..."
                      aria-label="Search" aria-describedby="basic-addon2" style="border-color: #3f51b5;">
                    <div class="input-group-append">
                      <button class="btn btn-primary" type="button">
                        <i class="fas fa-search fa-sm"></i>
                      </button>
                    </div>
                  </div>
                </form>
              </div>
            </li>

            <div class="topbar-divider d-none d-sm-block"></div>
            <li class="nav-item dropdown no-arrow">
              <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-toggle="dropdown"
                aria-haspopup="true" aria-expanded="false">
                <img class="img-profile rounded-circle" src="dashboard/img/boy.png" style="max-width: 60px">
                <span class="ml-2 d-none d-lg-inline text-white small">Junaid Imtiaz</span>
              </a>
              
              <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="userDropdown">
                <a class="dropdown-item" href="forms.html">
                  <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                  Profile
                </a>
                <a class="dropdown-item" href="#">
                  <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                  Settings
                </a>
                <a class="dropdown-item" href="../features.php">
                  <i class="fas fa-list fa-sm fa-fw mr-2 text-gray-400"></i>
                  Business Features
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="logout.php">
                  <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                  Logout
                </a>
              </div>
            </li>
          </ul>
        </nav>
        <!-- Topbar -->

        <!-- Container Fluid-->
        <div class="container-fluid" id="container-wrapper">
          <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">View Registration Forms</h1>
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="registrationform.php">Home</a></li>
              <li class="breadcrumb-item active" aria-current="page">View Registration Forms</li>
            </ol>
          </div>

          <!-- RowStartedRightMain -->
          <div class="row mb-3">     
                      <!-- DataTable with Hover -->
            <div class="col-lg-12">
              <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                  <h6 class="m-0 font-weight-bold text-primary">View Registration Forms Detail</h6>
                </div>
                <div class="table-responsive p-3">
                  <table class="table align-items-center table-flush table-hover" id="dataTableHover">
                    <thead class="thead-light">
                      <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Course</th>
                        <th>Email</th>
                        <th>Date</th>
                        <th>Operation</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      // Fetch and display registration form data
                      $query = "SELECT * FROM `registrationform`";
                      $run = mysqli_query($conn, $query);
                      while ($row = mysqli_fetch_array($run)) {
                        $id = $row[0];
                        $fullname = $row[3];
                        $coursename = $row[12];
                        $email = $row[7];
                        $entrydate = $row[15];
                      ?>
                      <tr>
                        <td><?php echo $id; ?></td>
                        <td><?php echo $fullname; ?></td>
                        <td><?php echo $coursename; ?></td>
                        <td><?php echo $email; ?></td>
                        <td><?php echo $entrydate; ?></td>
                        <td>
                          <a href="generate_pdf.php?id=<?php echo $id; ?>" target="_blank" title="Registration Form" data-toggle="tooltip">
                             <i class="fas fa-fw fa fa fa-registered" style="color: green;"></i>
                          </a>
                          <a href="aiform_pdf.php?id=<?php echo $id; ?>" target="_blank" title="AI Form" data-toggle="tooltip">
                             <i class="fa fa-font " style="color: chocolate;"></i>
                          </a>
                          <a href="inductionform_pdf.php?id=<?php echo $id; ?>" target="_blank" title="Induction Form" data-toggle="tooltip">
                             <i class="fa fa-info-circle" style="color: blue;"></i>
                          </a>
                          <a href="competencyform_pdf.php?id=<?php echo $id; ?>" target="_blank" title="Competency Form" data-toggle="tooltip">
                             <i class="fa fa-copyright" style="color: grey;"></i>
                          </a>
                        </td>
                      </tr>
                      <?php } ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

          <!--Row-->

          <!--RowEndedRightMain-->

        </div>
        <!---Container Fluid-->
      </div>
      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; 2019 - developed by
              <b><a href="https://twitter.com/ijunaidimtiaz" target="_blank">Junaid Imtiaz</a></b>
            </span>
          </div>
        </div>
      </footer>
      <!-- Footer -->
    </div>
  </div>

  <!-- Scroll to top -->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>

  <script src="dashboard/vendor/jquery/jquery.min.js"></script>
  <script src="dashboard/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="dashboard/vendor/jquery-easing/jquery.easing.min.js"></script>
  <script src="dashboard/js/ruang-admin.min.js"></script>
  <script src="dashboard/vendor/chart.js/Chart.min.js"></script>
  <script src="dashboard/js/demo/chart-area-demo.js"></script>
  <!-- Page level plugins -->
  <script src="dashboard/vendor/datatables/jquery.dataTables.min.js"></script>
  <script src="dashboard/vendor/datatables/dataTables.bootstrap4.min.js"></script>

  <!-- Page level custom scripts -->
  <script>
    $(document).ready(function () {
      $('#dataTable').DataTable(); // ID From dataTable 
      $('#dataTableHover').DataTable(); // ID From dataTable with Hover
    });
  </script>
</body>

</html>

<?php
// Close database connection
mysqli_close($conn);
?>
