<?php
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    // Database connection (Update credentials as per your database)
    $conn = mysqli_connect('localhost', 'tqualcou', 'Technocrats.59', 'tqualcou_tiosh');

    // Check connection
    if (!$conn) {
        die("Connection failed: " . mysqli_connect_error());
    }

    // Fetch data based on ID
    $query = "SELECT * FROM registrationform WHERE id = $id";
    $result = mysqli_query($conn, $query);

    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);

        // Add 15 days to the entrydate
        $entryDate = new DateTime($row['entrydate']);
        $entryDate->modify('+15 days');
        $updatedDate = $entryDate->format('d-m-Y'); // Format as desired (dd-mm-yyyy)

        // Include TCPDF library
        require_once('TCPDF/tcpdf.php');

        // Path to your logo file
        $logo = 'img/TIOSHLogoOnly.png';

        // Check if the logo file exists
        if (!file_exists($logo)) {
            die('Logo file does not exist or is inaccessible: ' . $logo);
        }

        // Create a new TCPDF instance
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        // Set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Muhammad Junaid Imtiaz');
        $pdf->SetTitle('Induction Form');
        $pdf->SetSubject('Induction Form Data');
        $pdf->SetKeywords('TIOSH, Induction Form, PDF');

        // Set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

        // Set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // Set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // Set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // Set header with logo
        $pdf->SetHeaderData($logo, PDF_HEADER_LOGO_WIDTH, 'TIOSH Pvt Limited', 'Documentation');

        // Add a page
        $pdf->AddPage();

        // Set some styles for better presentation
        $pdf->SetFont('helvetica', 'B', 30); // Title font size

        // Title
        $pdf->Cell(0, 10, 'Induction Form', 0, 1, 'C');

        // Set background color and light color lines
        $pdf->SetFillColor(240, 240, 240); // Light gray background
        $pdf->SetDrawColor(200, 200, 200); // Light gray lines

        // Personal Information Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Learner Registration Detail', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'First Name: ' . $row['firstname'] . "\n" .
            'Last Name: ' . $row['lastname'] . "\n" .
            'Full Name: ' . $row['fullname'] . "\n" .
            'Date of Birth: ' . $row['dob'],
            0, 'L', true
        );

        // Additional Details Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Topics Discuss in Induction', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'Roles and responsibilities of the Assessment '  . "\n" .
            'Roles and responsibilities of the candidates ' . "\n" .
            'Learner resume available and discussed '  . "\n" .
            'Roles and responsibilities of the approved center and coordinator ' . "\n" .
            'Appeals Procedures '. "\n" .
            'Data Protection and Documents Confidentiality '  . "\n" .
            'Qualification Structure '  . "\n" .
            'Assessment Documents (Planning and Feedback) ' . "\n" .
            'Knowledge and Understanding Requirements ' . "\n" .
            'Candidate Certification on Completion and Verification ' . "\n" .
            'Partly Completed Qualifications and Certification Options ' . "\n" .
            'Artificial Intelligence Guidance ' ,
            0, 'L', true
        );

        // Course Information Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'I agree that assessor had explained these points in my induction.', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'Course Name: ' . $row['coursename'],
            0, 'L', true
        );

        // Add a line for signature with better formatting
        $pdf->Ln(10);
        $pdf->SetFont('helvetica', '', 12);
        $pdf->Cell(0, 10, 'Learner Name: ' . $row['fullname'], 0, 1, 'L');
        
        // Add the signature image
        $signatureImagePath = 'uploads/signature/' . $row['signature']; // Adjust path if needed
        $pdf->Image($signatureImagePath, '', '', 60, 20, 'JPEG', '', '', true, 150, '', false, false, 1, false, false, false);

        // Display the updated date with a 15-day gap
        $pdf->Cell(0, 10, 'Date: ' . $updatedDate, 0, 1, 'R');

        // Close and output PDF document
        $filename = 'Induction Form of ' . urlencode($row['fullname']) . '.pdf';
        $pdf->Output($filename, 'I');
        exit;
    } else {
        echo 'No data found.';
    }

    mysqli_close($conn); // Close database connection
} else {
    echo 'Invalid request.';
}
?>
