<?php
if(isset($_GET['id'])) {
    $id = $_GET['id'];

    // Database connection (Update credentials as per your database)
    $conn =  mysqli_connect('localhost', 'tqualcou', 'Technocrats.59', 'tqualcou_tiosh');

    // Check connection
    if (!$conn) {
        die("Connection failed: " . mysqli_connect_error());
    }

    // Fetch data based on ID
    $query = "SELECT * FROM registrationform WHERE id = $id";
    $result = mysqli_query($conn, $query);

    if(mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);

        // Include TCPDF library
        require_once('TCPDF/tcpdf.php');

        // Path to your logo file
        $logo = 'img/TIOSHLogoOnly.png';

        // Check if the logo file exists
        if (!file_exists($logo)) {
            die('Logo file does not exist or is inaccessible: ' . $logo);
        }

        // Create a new TCPDF instance
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        // Set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Muhammad Junaid Imtiaz');
        $pdf->SetTitle('Registration Form');
        $pdf->SetSubject('Registration Form Data');
        $pdf->SetKeywords('TIOSH, Registration Form, PDF');

        // Set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

        // Set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // Set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // Set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // Set header with logo
        $pdf->SetHeaderData($logo, PDF_HEADER_LOGO_WIDTH, 'TIOSH Pvt Limited', 'Documentation');

        // Add a page
        $pdf->AddPage();

        // Set some styles for better presentation
        $pdf->SetFont('helvetica', 'B', 30); // Title font size

        // Title
        $pdf->Cell(0, 10, 'Registration Form', 0, 1, 'C');

        // Set background color and light color lines
        $pdf->SetFillColor(240, 240, 240); // Light gray background
        $pdf->SetDrawColor(200, 200, 200); // Light gray lines

        // Personal Information Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Personal Information', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'First Name: ' . $row['firstname'] . "\n" .
            'Last Name: ' . $row['lastname'] . "\n" .
            'Full Name: ' . $row['fullname'] . "\n" .
            'Designation: ' . $row['designation'] . "\n" .
            'Date of Birth: ' . $row['dob'] . "\n" .
            'Contact Number: ' . $row['contactnumber'] . "\n" .
            'Email: ' . $row['email'] . "\n" .
            'Postal Address: ' . $row['postaladdress'],
            0, 'L', true
        );

        // Additional Details Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Additional Details', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'Learning Difficulties: ' . $row['learningdifficulty'] . "\n" .
            'Disabilities: ' . $row['anydisability'] . "\n" .
            'Ethnicity: ' . $row['ethnicity'],
            0, 'L', true
        );

        // Course Information Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Course Information', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'Course Name: ' . $row['coursename'],
            0, 'L', true
        );

        // Documents Information Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Attached Documents', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);

// Create clickable link for Resume (Downloadable)
// Check if resume file exists and create clickable link
$resumeFile = 'uploads/resume/' . $row['resume']; // Direct file path
if (file_exists($resumeFile)) {
    // Construct URL with proper encoding
    $resumeFileURL = 'http://' . $_SERVER['HTTP_HOST'] . '/uploads/resume/' . rawurlencode($row['resume']); // Use rawurlencode for URL
    
    // Create clickable link
    $pdf->writeHTMLCell(0, 0, '', '', 'Resume: <a href="' . $resumeFileURL . '" style="color:blue; text-decoration:none;">' . htmlspecialchars($row['resume']) . '</a>', 0, 1, 0, true, 'L', true);
} else {
    $pdf->Cell(0, 10, 'Resume file not found.');
}

// Create clickable link for ID-Card (Downloadable)
$idcardLink = 'uploads/idcard/' . rawurlencode($row['idcard']);
$pdf->SetFont('helvetica', '', 12);
$pdf->Write(10, 'ID-Card: '); // Output the label without line break
$pdf->SetTextColor(0, 0, 255); // Set text color to blue for link
$pdf->Write(10, $row['idcard'], $idcardLink); // Display the link
$pdf->SetTextColor(0); // Reset text color
$pdf->Ln(); // Add a line break after the link

// Create clickable link for Signature (Downloadable)
$signatureLink = 'uploads/signature/' . rawurlencode($row['signature']);
$pdf->SetFont('helvetica', '', 12);
$pdf->Write(10, 'Signature: '); // Output the label without line break
$pdf->SetTextColor(0, 0, 255); // Set text color to blue for link
$pdf->Write(10, $row['signature'], $signatureLink); // Display the link
$pdf->SetTextColor(0); // Reset text color
$pdf->Ln(); // Add a line break after the link


        // Close and output PDF document
       $filename = 'Registration Form of ' . urlencode($row['fullname']) . '.pdf';
        $pdf->Output($filename, 'I');
        exit;
    } else {
        echo 'No data found.';
    }

    mysqli_close($conn); // Close database connection
} else {
    echo 'Invalid request.';
}
?>
