<?php
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    // Database connection (Update credentials as per your database)
    $conn = mysqli_connect('localhost', 'tqualcou', 'Technocrats.59', 'tqualcou_tiosh');

    // Check connection
    if (!$conn) {
        die("Connection failed: " . mysqli_connect_error());
    }

    // Fetch data based on ID
    $query = "SELECT * FROM registrationform WHERE id = $id";
    $result = mysqli_query($conn, $query);

    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);

        // Add 15 days to the entrydate
        $entryDate = new DateTime($row['entrydate']);
        $entryDate->modify('+15 days');
        $updatedDate = $entryDate->format('d-m-Y'); // Format as desired (dd-mm-yyyy)

        // Include TCPDF library
        require_once('TCPDF/tcpdf.php');

        // Path to your logo file
        $logo = 'img/TIOSHLogoOnly.png';

        // Check if the logo file exists
        if (!file_exists($logo)) {
            die('Logo file does not exist or is inaccessible: ' . $logo);
        }

        // Create a new TCPDF instance
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        // Set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Muhammad Junaid Imtiaz');
        $pdf->SetTitle('Competency Evaluation Form');
        $pdf->SetSubject('Competency Evaluation Form');
        $pdf->SetKeywords('TIOSH, Competency Evaluation Form, PDF');

        // Set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

        // Set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // Set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // Set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // Set header with logo
        $pdf->SetHeaderData($logo, PDF_HEADER_LOGO_WIDTH, 'TIOSH Pvt Limited', 'Documentation');

        // Add a page
        $pdf->AddPage();

        // Set some styles for better presentation
        $pdf->SetFont('helvetica', 'B', 20); // Title font size

        // Title
        $pdf->Cell(0, 10, 'Competency Evaluation Form', 0, 1, 'C');

        // Set background color and light color lines
        $pdf->SetFillColor(240, 240, 240); // Light gray background
        $pdf->SetDrawColor(200, 200, 200); // Light gray lines


          // Declaration Section
        $pdf->Ln(10);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Declaration by Learner', 0, 1, 'L', true);
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'This document provides us with an assessment of how much you are capable for NVQ to complete on your own without the need for further help, guidance, or training. You can fill it out thinking about your previous or present employment experiences. After you have finished, email it back to your assessor, who will determine if you are applying for the right degree and/or whether you need areas of mentorship and advice.'
        );

        // Personal Information Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Learner Registration Detail', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'First Name: ' . $row['firstname'] . "\n" .
            'Last Name: ' . $row['lastname'] . "\n" .
            'Full Name: ' . $row['fullname'] . "\n" .
            'Date of Birth: ' . $row['dob'] . "\n" .
            'Course Name: ' . $row['coursename'],
            0, 'L', true
        );

        // Additional Details Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'I handle these tasks in my workplace', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            '1-Advocating, developing and communicating a positive H&S culture for the organization'  . "\n" .
            '2-Working with key stakeholders in implementing a positive H&S culture' . "\n" .
            '3-Maintaining a positive H&S culture in your organization by encouraging directors, senior, line, functional and technical managers and employee representatives to lead by example on health and safety matters'  . "\n" .
            '4-Developing the H&S policy with respect to the statutory and organisational requirements' . "\n" .
            '5-Advocating and implementing the H&S policy to all key stakeholders'. "\n" .
            '6-Working with key stakeholders in order to integrate H&S into your organization'  . "\n" .
            '7-Evaluating H&S information external to your organisation'  . "\n" .
            '8-Communicating relevant H&S information through an effective system within your organization' . "\n" .
            '9-Ensuring that relevant H&S information from their organisation is communicated to statutory and local authorities, relevant groups and individuals' . "\n" .
            '10-Assessing the H&S competence needs of your organisation' . "\n" .
            '11-Assessing the H&S competence needs of individuals in your organisation' . "\n" .
            '12-Ensuring that the identiﬁed H&S competence needs of your organisation are addressed by providing health and safety training.' . "\n" .
            '13-Developing skills and knowledge in managing and implementing the risk assessment process for their organization' . "\n" .
            '14-Developing and implementing H&S reactive performance (loss event) monitoring systems' . "\n" .
            '15-Developing and implementing loss event investigation systems and procedures ' . "\n" .
            '16-Reviewing and responding to H&S reactive performance monitoring outcomes' . "\n" .
            '17-Developing skills and knowledge in planning and implementing emergency response systems, procedures and communicating' . "\n" .
            '18-Investigating the eﬃciency and cost-effectiveness of H&S management systems' . "\n" .
            '19-Developing and implementing changes to improve the eﬃciency and cost-effectiveness of the H&S management systems' . "\n" .
            '20-Maintain CPD Participate in meetings' . "\n" .
            '21-Analyse best practice and discuss with others',
            0, 'L', true
        );

        // Course Information Section
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'I am aware that I am undertaking these duties in my HSE workplace.', 'B', 1, 'L', true); // Bottom border
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'Learner Name: ' . $row['fullname'],
            0, 'L', true
        );

                
        // Add the signature image
        $signatureImagePath = 'uploads/signature/' . $row['signature']; // Adjust path if needed
        $pdf->Image($signatureImagePath, '', '', 60, 20, 'JPEG', '', '', true, 150, '', false, false, 1, false, false, false);

        // Display the updated date with a 15-day gap
        $pdf->Cell(0, 10, 'Date: ' . $updatedDate, 0, 1, 'R');

        // Close and output PDF document
        $filename = 'Competency Evaluation Form of ' . urlencode($row['fullname']) . '.pdf';
        $pdf->Output($filename, 'I');
        exit;
    } else {
        echo 'No data found.';
    }

    mysqli_close($conn); // Close database connection
} else {
    echo 'Invalid request.';
}
?>
