<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Define the absolute path to TCPDF
$tcpdf_path = '/home2/tqualcou/techiosh.com/TCPDF/tcpdf.php'; // Use absolute path

if (!file_exists($tcpdf_path)) {
    die('TCPDF file not found: ' . $tcpdf_path);
}
require_once($tcpdf_path);

if (isset($_GET['id'])) {
    $id = $_GET['id'];

    // Database connection (Update credentials as per your database)
    $conn = mysqli_connect("localhost", "tqualcou", "Technocrats.59", "tqualcou_tiosh");

    // Check connection
    if (!$conn) {
        die("Connection failed: " . mysqli_connect_error());
    }

    // Fetch data based on ID
    $query = "SELECT * FROM registrationform WHERE id = $id";
    $result = mysqli_query($conn, $query);

    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);

        // Path to your logo file
        $logo = 'img/TIOSHLogoOnly.png';

        // Check if the logo file exists
        if (!file_exists($logo)) {
            die('Logo file does not exist or is inaccessible: ' . $logo);
        }

        // Create a new TCPDF instance
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        // Set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Muhammad Junaid Imtiaz');
        $pdf->SetTitle('Artificial Intelligence Form');
        $pdf->SetSubject('Artificial Intelligence Form Data');
        $pdf->SetKeywords('TIOSH, Artificial Intelligence Form, PDF');

        // Set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

        // Set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        // Set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

        // Set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

        // Set header with logo
        $pdf->SetHeaderData($logo, PDF_HEADER_LOGO_WIDTH, 'TIOSH Pvt Limited', 'Documentation');

        // Add a page
        $pdf->AddPage();

        // Set some styles for better presentation
        $pdf->SetFont('helvetica', 'B', 25); // Title font size

        // Title
        $pdf->Cell(0, 10, 'Authenticity Statement Form', 0, 1, 'C');

        // Set background color and light color lines
        $pdf->SetFillColor(240, 240, 240); // Light gray background
        $pdf->SetDrawColor(200, 200, 200); // Light gray lines

        // Declaration Section
        $pdf->Ln(10);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Declaration by Learner', 0, 1, 'L', true);
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'My name is ' . $row['fullname'] . ', and I am currently enrolled in ' . $row['coursename'] . ', hereby I declare that:' . "\n\n" .
            '• No artificial intelligence (AI) was used in the development or fulfillment of my qualification work.' . "\n\n" .
            '• I certify that every piece of work I\'ve submitted under my name is the product of my own efforts, backed up only by my own original analysis.' . "\n\n" .
            '• I stress that the sources, materials, and information I have used in my work are the result of careful investigation and in-depth study in the pertinent field.' . "\n\n" .
            '• I certify that my daily efforts in pursuit of my qualifications, as well as in any professional context, add credibility to the items I have created.' . "\n\n" .
            '• If any malpractice pertaining to my usage of artificial intelligence (AI) in my coursework be uncovered, I accept full responsibility for it.' . "\n\n" .
            '• Any unauthorized use of AI tools or technologies that I may have used for work is included in this.' . "\n\n" .
            '• In light of this, I acknowledge that the TIOSH has given me access to the relevant policies, such as the AI Guidelines, the Plagiarism Policy, and the Malpractice Policy. I agree to uphold the ideals described in these policies, which I was made aware of throughout the registration process.' . ""
        );

        // Confirmation by Learner
        $pdf->Ln(10);
        $pdf->SetFont('helvetica', 'B', 14);
        $pdf->Cell(0, 10, 'Confirmation by Learner', 0, 1, 'L', true);
        $pdf->SetFont('helvetica', '', 12);
        $pdf->MultiCell(0, 10, 
            'I am aware of the seriousness of this statement and the repercussions of cheating. I now attest that I have read this declaration and that I understand its contents. I promise to uphold the values of honesty and qualification during my qualification process by signing my name below.'
        );

        // Add a line for signature with better formatting
        $pdf->Ln(10);
        $pdf->SetFont('helvetica', '', 12);
        $pdf->Cell(0, 10, 'Learner Name: ' . $row['fullname'], 0, 1, 'L');
        
        // Add the signature image
        $signatureImagePath = 'uploads/signature/' . $row['signature']; // Adjust path if needed
        
        if (file_exists($signatureImagePath)) {
            $fileInfo = pathinfo($signatureImagePath);
            $fileExtension = strtolower($fileInfo['extension']);
            
            if ($fileExtension === 'jpg' || $fileExtension === 'jpeg') {
                $pdf->Image($signatureImagePath, '', '', 60, 20, 'JPEG', '', '', true, 150, '', false, false, 1, false, false, false);
            } elseif ($fileExtension === 'pdf') {
                // Convert PDF to image
                // Use a PDF to image converter library/tool (e.g., ImageMagick)
                $imagePath = 'uploads/signature/' . $fileInfo['filename'] . '.png'; // Example conversion to PNG

                // Check if the image was successfully created
                if (file_exists($imagePath)) {
                    $pdf->Image($imagePath, '', '', 60, 20, 'PNG', '', '', true, 150, '', false, false, 1, false, false, false);
                } else {
                    $pdf->Cell(0, 10, 'Signature: image conversion failed because its uploaded in PDF format while it needs to attach in jpeg format: ' . $imagePath, 0, 1, 'L');
                }
            } else {
                $pdf->Cell(0, 10, 'Signature image is not in a supported format: ' . $signatureImagePath, 0, 1, 'L');
            }
        } else {
            $pdf->Cell(0, 10, 'Signature image not found: ' . $signatureImagePath, 0, 1, 'L');
        }

        $pdf->Cell(0, 10, 'Date: ' . $row['entrydate'], 0, 1, 'R');

        // Add a border around the main content for better visual separation
        $pdf->SetDrawColor(100, 100, 100); // Darker border color
        $pdf->Rect(10, 40, 190, $pdf->getY() - 40, 'D'); // Add border around content

        // Close and output PDF document
        $filename = 'Artificial_Intelligence_Form_of_' . urlencode(htmlspecialchars($row['fullname'])) . '.pdf';
        $pdf->Output($filename, 'I');
        exit;
    } else {
        echo 'No data found.';
    }

    mysqli_close($conn); // Close database connection
} else {
    echo 'Invalid request.';
}
?>
